













{{--
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-left">
            <h2>Create New Release</h2>
        </div>
        <div class="pull-right">
            <a class="btn btn-primary btn-sm mb-2" href="{{ route('release.index') }}"><i class="fa fa-arrow-left"></i> Back</a>
</div>
</div>
</div>

<ul class="nav nav-tabs" role="tablist">

    <li class="nav-item">
        <a class="nav-link active" data-bs-toggle="tab" href="#releasetab">Release</a>
    </li>

    <li class="nav-item">
        <a class="nav-link" href="javascript:void(0)">Audio Files</a>
    </li>


    <li class="nav-item">
        <a class="nav-link" href="javascript:void(0)">Splits</a>
    </li>

    <li class="nav-item">
        <a class="nav-link" href="javascript:void(0)">Territories</a>
    </li>


    <li class="nav-item">
        <a class="nav-link" href="javascript:void(0)">Deliveries</a>
    </li>

    <li class="nav-item">
        <a class="nav-link" href="javascript:void(0)">Finish</a>
    </li>
</ul>

@if (count($errors) > 0)
<div class="alert alert-danger">
    <label>Whoops!</label> There were some problems with your input.<br><br>
    <ul>
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<div class="tab-content">
    <div id="releasetab" class="container tab-pane active"><br>
        <form method="POST" action="{{ route('release.store') }}" id="frmReleaseStep1" enctype="multipart/form-data">
            @csrf

            <div class="row">

                <div class="col-xs-12 col-sm-12 col-md-12 d-flex">
                    <a href="javascript:void(0);">
                        <button class="btn btn-success" type="button">Luminate ISRC Registration</button>
                    </a>&nbsp;&nbsp;

                    <a href="javascript:void(0);">
                        <button class="btn btn-success" type="button">Luminate Title Registration</button>
                    </a>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Language:</label>
                        <input type="text" name="lang" class="form-control" value="{{ old('lang') }}" />
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">Choose Primary Artist:</label>
                        <select name="artists" id="artists" class="form-control" required>
                            <option value="">Select Artist</option>
                            @foreach($artists as $artist)
                            <option value="{{ $artist->id }}" @if(old('artists')==$artist->id) selected @endif>{{ ucfirst($artist->name) }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Display Artist:</label>
                        <input type="text" name="display_artist" class="form-control" value="{{ old('display_artist') }}" />
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Featured Artist:</label>
                        <input type="text" name="feature_artist" class="form-control" value="{{ old('feature_artist') }}" />
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Remixer:</label>
                        <input type="text" name="remixer" class="form-control" value="{{ old('remixer') }}" />
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">Composer:</label>
                        <input type="text" name="composer" class="form-control" required value="{{ old('composer') }}" />
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Orchestra:</label>
                        <input type="text" name="orchestra" class="form-control" value="{{ old('orchestra') }}" />
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Arranger:</label>
                        <input type="text" name="arranger" class="form-control" value="{{ old('arranger') }}" />
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Actor:</label>
                        <input type="text" name="actor" class="form-control" value="{{ old('actor') }}" />
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Conductor:</label>
                        <input type="text" name="conductor" class="form-control" value="{{ old('conductor') }}" />
                    </div>
                </div>


                <h5 class="required">Is Instrumental?</h5>
                <div class="col-xs-6 col-sm-6 col-md-6 d-flex">

                    <div class="form-group">
                        <input type="radio" name="is_instrumental" value="1" class="form-check-input" @if(old('is_instrumental')==1) selected @endif />
                        <label>Yes:</label>
                    </div>

                    <div class="form-group">
                        <input type="radio" checked name="is_instrumental" value="0" class="form-check-input" @if(old('is_instrumental')==0) selected @endif />
                        <label>No:</label>
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6" id="lyricistData">
                    <div class="form-group d-flex">
                        <label>Lyricist:</label>
                        <input type="text" name="lyricist_firstname" placeholder="First Name" class="form-control" value="{{ old('lyricist_firstname') }}" />
                        <input type="text" name="lyricist_lastname" placeholder="Last Name" class="form-control" value="{{ old('lyricist_lastname') }}" />
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">Release Title:</label>
                        <input type="text" name="title" class="form-control" required value="{{ old('title') }}" />
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Label:</label>
                        <select name="label_id" id="label_id" class="form-control">
                            <option value="">Select Label</option>
                            @foreach($users as $user)
                            <option value="{{ $user->id }}" @if(old('label_id')==$user->id) selected @endif >{{ ucfirst($user->name) }}</option>
                            @endforeach
                        </select>
                        <a href="{{ route('users.create') }}?release=createRelease"><button class="btn btn-success" type="button">Add Lable</button></a>
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">ArtWork:</label>
                        <input type="file" name="artwork" class="form-control" required />
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">Motion Art for apple:</label>
                        <input type="file" name="apple_art" class="form-control" required />
                    </div>
                </div>


                <h5>Release Type</h5>
                <div class="col-xs-6 col-sm-6 col-md-6 d-flex">
                    <div class="form-group">
                        <input type="radio" checked name="release_type" value="release" class="form-check-input" @if(old('release_type')=="release" ) selected @endif />
                        <label>Release:</label>
                    </div>

                    <div class="form-group">
                        <input type="radio" name="release_type" value="album" class="form-check-input" @if(old('release_type')=="album" ) selected @endif />
                        <label>Album:</label>
                    </div>

                    <div class="form-group">
                        <input type="radio" name="release_type" value="mix" class="form-check-input" @if(old('release_type')=="mix" ) selected @endif />
                        <label>Mix:</label>
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">Catalog Number:</label>
                        <input type="text" name="cat_number" class="form-control" required value="{{ old('cat_number') }}" />
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Main Genre:</label>
                        <select name="genre_id" id="genre_id" class="form-control">
                            <option value="">Select Genre</option>
                            @foreach($genres as $genre)
                            <option value="{{ $genre->id }}" @if(old('genre_id')==$genre->id) selected @endif >{{ ucfirst($genre->title) }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6" id="subgenredata">
                    <div class="form-group">
                        <label>Sub Genre:</label>
                        <select name="subgenre_id" id="subgenre_id" class="form-control">
                            <option value="">Select Sub Genre</option>
                        </select>
                    </div>
                </div>

                <h5>Do you have UPC</h5>

                <div class="col-xs-6 col-sm-6 col-md-6 d-flex">
                    <div class="form-group">
                        <input type="radio" checked name="is_upc" value="1" class="form-check-input" />
                        <label>Yes:</label>
                    </div>


                    <div class="form-group">
                        <input type="radio" name="is_upc" value="0" class="form-check-input" />
                        <label>No:</label>
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6" id="upcnumberData">
                    <div class="form-group d-flex">
                        <label>UPC/EAN:</label>
                        <input type="text" name="upc_number" class="form-control" value="{{ old('upc_number') }}" />
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">Release Date:</label>
                        <input type="datetime-local" name="release_date" class="form-control" required value="{{ old('release_date') }}" />
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">P Line:</label>
                        <input type="text" name="p_line" placeholder="P-Line" class="form-control" required value="{{ old('p_line') }}" />
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">C Line:</label>
                        <input type="text" name="c_line" placeholder="C-Line" class="form-control" required value="{{ old('c_line') }}" />
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Copyrights:</label>
                        <input type="text" name="copyrights" placeholder="Copyrights" class="form-control" value="{{ old('copyrights') }}" />
                    </div>
                </div>



                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Price Tiers(For ITunes Only):</label>
                        <select name="price_tier" id="price_tier" class="form-control">
                            <option value="">Select Price Tier</option>

                            @foreach(release_prices_tires() as $price_key => $price_val)
                            <option value="{{ $price_key}}" @if(old('price_tier')==$price_key) selected @endif>
                                {{ $price_val }}
                            </option>
                            @endforeach

                        </select>
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Parental Warning Types:</label>
                        <select name="parental_warning_type" id="parental_warning_type" class="form-control">
                            <option value="NotExplicit" @if(old('parental_warning_type')=="NotExplicit" ) selected @endif>NotExplicit</option>
                            <option value="Explicit" @if(old('parental_warning_type')=="Explicit" ) selected @endif>Explicit</option>
                            <option value="ExplicitContentEdited" @if(old('parental_warning_type')=="ExplicitContentEdited" ) selected @endif>ExplicitContentEdited</option>
                        </select>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    <div class="form-group">
                        <label>Release Description:</label>
                        <textarea style="height: 131px;" name="description" id="description" class="form-control">{{ old('description') }}</textarea>
                    </div>
                </div>


                <div class="col-xs-12 col-sm-12 col-md-12">
                    <button type="submit" class="btn btn-primary btn-sm mt-2 mb-3"><i class="fa-solid fa-floppy-disk"></i> Next</button>
                </div>

            </div>
        </form>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            $("#frmReleaseStep1").validate({
                rules: {
                    artists: {
                        required: true
                    },
                    is_instrumental: {
                        required: true
                    },
                    title: {
                        required: true
                    },

                    cat_number: {
                        required: true
                    },

                    p_line: {
                        required: true
                    },

                    c_line: {
                        required: true
                    },

                    composer: {
                        required: true
                    },
                },
                messages: {
                    artists: {
                        required: "Artists field is required"
                    },
                    is_instrumental: {
                        required: "Is Instrument field is required"
                    },
                    title: {
                        required: "Title field is required"
                    },
                    cat_number: {
                        required: "Catalog Number field is required"
                    },
                    p_line: {
                        required: "P Line field is required"
                    },

                    c_line: {
                        required: "C Line field is required"
                    },

                    composer: {
                        required: "Composer field is required"
                    },
                }
            });
        });

        $("input:radio[name=is_instrumental]").click(function() {
            if ($('input:radio[name=is_instrumental]:checked').val() == "0") {
                $('#lyricistData').show();
            }
            if ($('input:radio[name=is_instrumental]:checked').val() == "1") {
                $('#lyricistData').hide();
            }
        });

        $("input:radio[name=is_upc]").click(function() {
            if ($('input:radio[name=is_upc]:checked').val() == "1") {
                $('#upcnumberData').show();
            }
            if ($('input:radio[name=is_upc]:checked').val() == "0") {
                $('#upcnumberData').hide();
            }
        });

        $("#genre_id").change(function() {
            var genre_id = $(this).val();
            $.ajax({
                url: "{{ route('release.subgenre') }}",
                type: "POST",
                data: {
                    'genre_id': genre_id,
                    "_token": "{{ csrf_token() }}"
                },
                cache: false,
                success: function(html) {
                    html = html.replace("<strong>", "<label>");
                    html = html.replace("</strong>", "</label>");
                    $("#subgenredata").html(html);
                },
                error: function(textStatus, errorThrown) {
                    alert('Something went wrong!');
                    return false;
                }
            });
        });
    </script>

    --}}
